SET SQL_SAFE_UPDATES=0;

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPOINTMENT_ONE_DAY_PRIOR_PARENT_RCPNT');

UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T1.id AS ID,
    ent.emailId AS EMAIL_ID,
    ent.mobileCountryCode AS MOBILE_CODE,
    ent.mobileNumber AS MOBILE_NO,
    ent.firstName AS FIRST_NAME,
    ent.lastName AS LAST_NAME,
    T3.printName AS PRINT_NAME,
    stPer.firstName AS STUDENT_FIRST_NAME,
    stPer.lastName AS STUDENT_LAST_NAME,
    stPer.printName AS STUDENT_PRINT_NAME,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.expectedOutTime, '%h:%i %p') AS OUT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
	sal.salutationName AS SALUTATION_NAME,
	TRIM(substring_index(appointeeName, '/', -1)) AS APPOINTEE_NAME,
    ml.code as LANGUAGE_KEY,
       T12.academyName AS ACADEMY_NAME,
    T12.locationName AS LOCATION_NAME,
    T12.displayName AS ACADEMY_NAME_LOCATION,
    T12.id AS ACADEMY_LOCATION_ID,
    (CASE
        WHEN
            T12.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T12.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
	(CASE
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T12.logoUrl)
    END) AS LOGO_URL
FROM
    `sg_appointment` T1
        LEFT JOIN
    staffs T2 ON T2.userId = T1.personToMeetId
        LEFT JOIN
    persons T3 ON T3.id = T2.personId
        INNER JOIN
    person_relationships parent ON parent.relatedPersonId = T1.parentId
        LEFT JOIN
    persons ent ON ent.id = parent.relatedPersonId
    LEFT JOIN
    persons stPer on parent.personId=stPer.id
    LEFT JOIN
	multi_language ml on stPer.correspondence_language=ml.id
     left join 
    salutations sal on ent.salutationId=sal.id
    left join
    academy_location T12 on T12.id=T1.academyLocationId
       LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams)" WHERE (`dataProviderId` = @dtproviderId);

SET SQL_SAFE_UPDATES=1;